<?php
require_once __DIR__ . '/config.php';
header("Content-Type: application/json");

$key = $_REQUEST['key'] ?? '';
$device = (int)($_REQUEST['device'] ?? $SMS_CONFIG['device_id']);
$to = $_REQUEST['to'] ?? '';
$msg = $_REQUEST['msg'] ?? '';

if ($key !== $SMS_CONFIG['api_key']) {
    echo json_encode(['status'=>'error','message'=>'Invalid API Key']);
    exit;
}

if ($to === '' || $msg === '') {
    echo json_encode(['status'=>'error','message'=>'Missing parameters']);
    exit;
}

$to = preg_replace('/\D+/', '', $to);

$jobId = uniqid("job_");

$queueFile = sms_queue_file($device);
$queue = ['jobs'=>[]];

if (file_exists($queueFile)) {
    $data = json_decode(file_get_contents($queueFile), true);
    if (!empty($data['jobs'])) $queue = $data;
}

$queue['jobs'][] = [
    'id' => $jobId,
    'to' => $to,
    'msg' => $msg,
    'time'=> time(),
];

file_put_contents($queueFile, json_encode($queue, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

sms_log("Queued SMS job=$jobId to=$to msg=" . mb_substr($msg,0,50));

echo json_encode(['status'=>'queued','job_id'=>$jobId]);
