<?php
require_once __DIR__ . '/config.php';
header("Content-Type: application/json; charset=utf-8");

$device = $SMS_CONFIG['device_id'];

// Log dosyasından son poll zamanını bulalım
$logFile = $SMS_CONFIG['log_file'];
$lastSeen = 0;

if (file_exists($logFile)) {
    $lines = array_reverse(file($logFile));
    foreach ($lines as $line) {
        if (strpos($line, "Device $device fetched job") !== false || 
            strpos($line, "Device $device REPORT") !== false ||
            strpos($line, "Device $device") !== false) {

            // Log başındaki tarihten timestamp çıkartalım
            preg_match('/\[(.*?)\]/', $line, $m);
            if (!empty($m[1])) {
                $lastSeen = strtotime($m[1]);
                break;
            }
        }
    }
}

$now = time();
$isOnline = false;

// 30 saniye içinde poll geldiyse cihaz bağlıdır
if ($lastSeen > 0 && ($now - $lastSeen) <= 5) {
    $isOnline = true;
}

echo json_encode([
    "status" => $isOnline ? "online" : "offline",
    "lastSeen" => $lastSeen,
    "lastSeenAgo" => $now - $lastSeen
]);
