<?php
require_once __DIR__ . '/config.php';
header("Content-Type: application/json; charset=utf-8");

$key = $_GET['key'] ?? '';
$device = (int)($_GET['device'] ?? 1);

if ($key !== $SMS_CONFIG['api_key']) {
    echo json_encode(['status'=>'error','message'=>'Invalid API Key']);
    exit;
}

$queueFile = sms_queue_file($device);

// HER POLL’DE LOG YAZILSIN (EN ÖNEMLİ SATIR)
sms_log("Device $device POLLED");

// Kuyruk yoksa boş dön
if (!file_exists($queueFile)) {
    echo json_encode(['status'=>'empty']);
    exit;
}

$data = json_decode(file_get_contents($queueFile), true);
if (empty($data['jobs'])) {
    echo json_encode(['status'=>'empty']);
    exit;
}

$job = array_shift($data['jobs']);
file_put_contents($queueFile, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

sms_log("Device $device fetched job={$job['id']}");

echo json_encode(['status'=>'ok','job'=>$job]);
